/*==========================================================================
  WMASK.C

  Example code to show effect of DP_WRITE_MASK register.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    unsigned long mask, save_dst_cntl;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // setup engine context and clear screen
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // Set write mask to pass all bits to destination
    wait_for_fifo (1);
    regw (DP_WRITE_MASK, 0xFFFFFFFF);

    // Draw a WHITE filled rectangle
    set_fg_color (get_color_code (WHITE));
    draw_rectangle (0, 0, modeinfo.xres / 2, modeinfo.yres / 2);

    // wait for a carriage return
    getch ();

    // setup mask for WRITE_MASK register

    // In 24 bpp mode, the rotation must be set BEFORE setting the write mask.
    if (modeinfo.bpp == 24)
    {
        wait_for_idle ();
        save_dst_cntl = regr (DST_CNTL);
        wait_for_fifo (1);
        regw (DST_CNTL, (save_dst_cntl & 0xF87F) | DST_24_ROTATION_ENABLE |
                        (GET24BPPROTATION (modeinfo.xres / 2) << 8));
    }

    switch (modeinfo.bpp)
    {
        case 4:
            mask = 0xFFFFFFF0;
            break;
        case 8:
            mask = 0xFFFFFF00;
            break;
        case 16:
            mask = 0xFFFF0000;
            break;
        case 24:
            mask = 0xFF000000;
            break;
        case 32:
            mask = 0x00000000;
            break;
    }

    // Set write mask to mask off bits giving a result color of
    // LIGHTMAGENTA without changing the DP_FRGD_CLR register value

    wait_for_fifo (1);
    regw (DP_WRITE_MASK, mask | get_color_code (LIGHTMAGENTA));

    // Draw a filled rectangle with the new write mask setting
    set_fg_color (get_color_code (WHITE));
    draw_rectangle (modeinfo.xres / 2, 0, modeinfo.xres / 2, modeinfo.yres / 2);

    // wait for a carriage return
    getch ();

    if (modeinfo.bpp == 24)
    {
        wait_for_fifo (1);
        regw (DST_CNTL, save_dst_cntl);
    }

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

