; ===========================================================================
; ATIM64.INC
;
; ASM include file that contains ATI MACH64 register definitions
;
; Copyright (c) 1993-94 ATI Technologies Inc.  All rights reserved
; ===========================================================================

; NON-GUI IO MAPPED Registers - BYTE offset

; Base I/O address:     BYTE offset,   02ECh, 01C8h, 01CCh, High 6 bits

ioCRTC_H_TOTAL_DISP     equ  0000h  ;  02ECh, 01C8h, 01CCh, 0000h
ioCRTC_H_SYNC_STRT_WID  equ  0400h  ;  06ECh, 05C8h, 05CCh, 0001h
ioCRTC_V_TOTAL_DISP     equ  0800h  ;  0AECh, 09C8h, 09CCh, 0002h
ioCRTC_V_SYNC_STRT_WID  equ  0C00h  ;  0EECh, 0DC8h, 0DCCh, 0003h
ioCRTC_VLINE_CRNT_VLINE equ  1000h  ;  12ECh, 11C8h, 11CCh, 0004h
ioCRTC_OFF_PITCH        equ  1400h  ;  16ECh, 15C8h, 15CCh, 0005h
ioCRTC_INT_CNTL         equ  1800h  ;  1AECh, 19C8h, 19CCh, 0006h
ioCRTC_GEN_CNTL         equ  1C00h  ;  1EECh, 1DC8h, 1DCCh, 0007h

ioOVR_CLR               equ  2000h  ;  22ECh, 21C8h, 21CCh, 0008h
ioOVR_WID_LEFT_RIGHT    equ  2400h  ;  26ECh, 25C8h, 25CCh, 0009h
ioOVR_WID_TOP_BOTTOM    equ  2800h  ;  2AECh, 29C8h, 29CCh, 000Ah

ioCUR_CLR0              equ  2C00h  ;  2EECh, 2DC8h, 2DCCh, 000Bh
ioCUR_CLR1              equ  3000h  ;  32ECh, 31C8h, 31CCh, 000Ch
ioCUR_OFFSET            equ  3400h  ;  36ECh, 35C8h, 35CCh, 000Dh
ioCUR_HORZ_VERT_POSN    equ  3800h  ;  3AECh, 39C8h, 39CCh, 000Eh
ioCUR_HORZ_VERT_OFF     equ  3C00h  ;  3EECh, 3DC8h, 3DCCh, 000Fh

ioSCRATCH_REG0          equ  4000h  ;  42ECh, 41C8h, 41CCh, 0010h
ioSCRATCH_REG1          equ  4400h  ;  46ECh, 45C8h, 45CCh, 0011h

ioCLOCK_CNTL            equ  4800h  ;  4AECh, 49C8h, 49CCh, 0012h
ioCLOCK_SEL_CNTL        equ  4800h  ;  4AECh, 49C8h, 49CCh, 0012h

ioBUS_CNTL              equ  4C00h  ;  4EECh, 4DC8h, 4DCCh, 0013h

ioMEM_CNTL              equ  5000h  ;  52ECh, 51C8h, 51CCh, 0014h
ioMEM_VGA_WP_SEL        equ  5400h  ;  56ECh, 55C8h, 55CCh, 0015h
ioMEM_VGA_RP_SEL        equ  5800h  ;  5AECh, 59C8h, 59CCh, 0016h

ioDAC_REGS              equ  5C00h  ;  5EECh, 5DC8h, 5DCCh, 0017h
ioDAC_CNTL              equ  6000h  ;  62ECh, 61C8h, 61CCh, 0018h

ioGEN_TEST_CNTL         equ  6400h  ;  66ECh, 65C8h, 65CCh, 0019h

ioCONFIG_CNTL           equ  6800h  ;  6AECh, 69C8h, 69CCh, 001Ah
ioCONFIG_CHIP_ID        equ  6C00h  ;  6EECh, 6DC8h, 6DCCh, 001Bh
ioCONFIG_STAT0          equ  7000h  ;  72ECh, 71C8h, 71CCh, 001Ch
ioCONFIG_STAT1          equ  7400h  ;  76ECh, 75C8h, 75CCh, 001Dh (GX/CX)
ioCRC_SIG               equ  7400h  ;  76ECh, 75C8h, 75CCh, 001Dh (CT/DT)

ioCRTC_H_TOTAL_DISP_ALIAS equ 7C00h ;  7EECh, 7DC8h, 7DCCh, 001Fh


; NON-GUI MEMORY MAPPED Registers - expressed in BYTE offsets */

CRTC_H_TOTAL_DISP       equ  0000h  ;  Dword offset 00h
CRTC_H_SYNC_STRT_WID    equ  0004h  ;  Dword offset 01h
CRTC_V_TOTAL_DISP       equ  0008h  ;  Dword offset 02h
CRTC_V_SYNC_STRT_WID    equ  000Ch  ;  Dword offset 03h
CRTC_VLINE_CRNT_VLINE   equ  0010h  ;  Dword offset 04h
CRTC_OFF_PITCH          equ  0014h  ;  Dword offset 05h
CRTC_INT_CNTL           equ  0018h  ;  Dword offset 06h
CRTC_GEN_CNTL           equ  001Ch  ;  Dword offset 07h

OVR_CLR                 equ  0040h  ;  Dword offset 10h
OVR_WID_LEFT_RIGHT      equ  0044h  ;  Dword offset 11h
OVR_WID_TOP_BOTTOM      equ  0048h  ;  Dword offset 12h

CUR_CLR0                equ  0060h  ;  Dword offset 18h
CUR_CLR1                equ  0064h  ;  Dword offset 19h
CUR_OFFSET              equ  0068h  ;  Dword offset 1Ah
CUR_HORZ_VERT_POSN      equ  006Ch  ;  Dword offset 1Bh
CUR_HORZ_VERT_OFF       equ  0070h  ;  Dword offset 1Ch

SCRATCH_REG0            equ  0080h  ;  Dword offset 20h
SCRATCH_REG1            equ  0084h  ;  Dword offset 21h

CLOCK_CNTL              equ  0090h  ;  Dword offset 24h
CLOCK_SEL_CNTL          equ  0090h  ;  Dword offset 24h

BUS_CNTL                equ  00A0h  ;  Dword offset 28h

MEM_CNTL                equ  00B0h  ;  Dword offset 2Ch

MEM_VGA_WP_SEL          equ  00B4h  ;  Dword offset 2Dh
MEM_VGA_RP_SEL          equ  00B8h  ;  Dword offset 2Eh

DAC_REGS                equ  00C0h  ;  Dword offset 30h
DAC_CNTL                equ  00C4h  ;  Dword offset 31h

GEN_TEST_CNTL           equ  00D0h  ;  Dword offset 34h

CONFIG_CNTL             equ  00DCh  ;  Dword offset 37h (GX rev F+)
CONFIG_CHIP_ID          equ  00E0h  ;  Dword offset 38h
CONFIG_STAT0            equ  00E4h  ;  Dword offset 39h
CONFIG_STAT1            equ  00E8h  ;  Dword offset 3Ah (GX/CX)
CRC_SIG                 equ  00E8h  ;  Dword offset 3Ah (CT/DT)


; GUI MEMORY MAPPED Registers

DST_OFF_PITCH           equ  0100h  ;  Dword offset 40h
DST_X                   equ  0104h  ;  Dword offset 41h
DST_Y                   equ  0108h  ;  Dword offset 42h
DST_Y_X                 equ  010Ch  ;  Dword offset 43h
DST_WIDTH               equ  0110h  ;  Dword offset 44h
DST_HEIGHT              equ  0114h  ;  Dword offset 45h
DST_HEIGHT_WIDTH        equ  0118h  ;  Dword offset 46h
DST_X_WIDTH             equ  011Ch  ;  Dword offset 47h
DST_BRES_LNTH           equ  0120h  ;  Dword offset 48h
DST_BRES_ERR            equ  0124h  ;  Dword offset 49h
DST_BRES_INC            equ  0128h  ;  Dword offset 4Ah
DST_BRES_DEC            equ  012Ch  ;  Dword offset 4Bh
DST_CNTL                equ  0130h  ;  Dword offset 4Ch

SRC_OFF_PITCH           equ  0180h  ;  Dword offset 60h
SRC_X                   equ  0184h  ;  Dword offset 61h
SRC_Y                   equ  0188h  ;  Dword offset 62h
SRC_Y_X                 equ  018Ch  ;  Dword offset 63h
SRC_WIDTH1              equ  0190h  ;  Dword offset 64h
SRC_HEIGHT1             equ  0194h  ;  Dword offset 65h
SRC_HEIGHT1_WIDTH1      equ  0198h  ;  Dword offset 66h
SRC_X_START             equ  019Ch  ;  Dword offset 67h
SRC_Y_START             equ  01A0h  ;  Dword offset 68h
SRC_Y_X_START           equ  01A4h  ;  Dword offset 69h
SRC_WIDTH2              equ  01A8h  ;  Dword offset 6Ah
SRC_HEIGHT2             equ  01ACh  ;  Dword offset 6Bh
SRC_HEIGHT2_WIDTH2      equ  01B0h  ;  Dword offset 6Ch
SRC_CNTL                equ  01B4h  ;  Dword offset 6Dh

HOST_DATA0              equ  0200h  ;  Dword offset 80h
HOST_DATA1              equ  0204h  ;  Dword offset 81h
HOST_DATA2              equ  0208h  ;  Dword offset 82h
HOST_DATA3              equ  020Ch  ;  Dword offset 83h
HOST_DATA4              equ  0210h  ;  Dword offset 84h
HOST_DATA5              equ  0214h  ;  Dword offset 85h
HOST_DATA6              equ  0216h  ;  Dword offset 86h
HOST_DATA7              equ  021Ch  ;  Dword offset 87h
HOST_DATA8              equ  0220h  ;  Dword offset 88h
HOST_DATA9              equ  0224h  ;  Dword offset 89h
HOST_DATAA              equ  0228h  ;  Dword offset 8Ah
HOST_DATAB              equ  022Ch  ;  Dword offset 8Bh
HOST_DATAC              equ  0230h  ;  Dword offset 8Ch
HOST_DATAD              equ  0234h  ;  Dword offset 8Dh
HOST_DATAE              equ  0238h  ;  Dword offset 8Eh
HOST_DATAF              equ  023Ch  ;  Dword offset 8Fh
HOST_CNTL               equ  0240h  ;  Dword offset 90h

PAT_REG0                equ  0280h  ;  Dword offset A0h
PAT_REG1                equ  0284h  ;  Dword offset A1h
PAT_CNTL                equ  0288h  ;  Dword offset A2h

SC_LEFT                 equ  02A0h  ;  Dword offset A8h
SC_RIGHT                equ  02A4h  ;  Dword offset A9h
SC_LEFT_RIGHT           equ  02A8h  ;  Dword offset AAh
SC_TOP                  equ  02ACh  ;  Dword offset ABh
SC_BOTTOM               equ  02B0h  ;  Dword offset ACh
SC_TOP_BOTTOM           equ  02B4h  ;  Dword offset ADh

DP_BKGD_CLR             equ  02C0h  ;  Dword offset B0h
DP_FRGD_CLR             equ  02C4h  ;  Dword offset B1h
DP_WRITE_MASK           equ  02C8h  ;  Dword offset B2h
DP_CHAIN_MASK           equ  02CCh  ;  Dword offset B3h
DP_PIX_WIDTH            equ  02D0h  ;  Dword offset B4h
DP_MIX                  equ  02D4h  ;  Dword offset B5h
DP_SRC                  equ  02D8h  ;  Dword offset B6h

CLR_CMP_CLR             equ  0300h  ;  Dword offset C0h
CLR_CMP_MASK            equ  0304h  ;  Dword offset C1h
CLR_CMP_CNTL            equ  0308h  ;  Dword offset C2h

FIFO_STAT               equ  0310h  ;  Dword offset C4h

CONTEXT_MASK            equ  0320h  ;  Dword offset C8h
CONTEXT_LOAD_CNTL       equ  032Ch  ;  Dword offset CBh

GUI_TRAJ_CNTL           equ  0330h  ;  Dword offset CCh
GUI_STAT                equ  0338h  ;  Dword offset CEh

