; ===========================================================================
; ROMCAL01.ASM
;
; Mach64 ROM interface function 01h - Set display mode.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_SETDISPLAYMODE - ROM function 01h
;
; Set display according to a previously call to LOAD_MODE_PARMS. Input
; parameters are fetched from the stack. See PGL.H for symbolic values.
;
; Inputs : WORD display mode
;            0 - VGA
;            1 - Accelerator
;
;          WORD palettized flag
;            0 - disabled
;            1 - enabled
;
;          DWORD PTR double clock flag pointer to WORD
;            filled with 0 for standard clocking
;            filled with 1 for double clocking
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_setdisplaymode

IFDEF mem_S
ROM_setdisplaymode proc near
ELSE
ROM_setdisplaymode proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    cx
            push    es

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     ax, WORD PTR [bp+PARM]      ; get resolution code
            and     ax, 1
            mov     cl, al
            mov     ax, WORD PTR [bp+PARM+2]    ; get palettized flag
            and     ax, 1
            shl     al, 7
            or      cl, al

            ; setup ROM call
            mov     ax, 1                       ; function 01h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; ROM will return double clock status in bit 5 of CL
            ;  0 - standard clocking
            ;  1 - double clocking
            mov     bx, WORD PTR [bp+PARM+6]    ; get pointer segment
            mov     es, bx
            mov     bx, WORD PTR [bp+PARM+4]    ; get pointer offset
            shr     cl, 5
            and     cx, 1
            mov     es:[bx], cx

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     es
            pop     cx
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_setdisplaymode endp

            end

