/*******************************************************************************
 *	ATI 3D RAGE SDK sample code												   *	
 *																			   *
 *  Knight Demo																   *
 *																			   *
 *  Copyright (c) 1996-1997 ATI Technologies, Inc.  All rights reserved.	   *	
 *																			   *
 * Written by Aaron Orenstein												   *
 *  																		   *
 *	The base sequence and set up for the Knight Demo dragon. Includes		   *
 *	initialization,	drawing, alpha-blending (for dragon's wings) and clean-up  *
 *	for modeling of the dragon.												   *
 *******************************************************************************/
#ifndef DRAGON_H
#define DRAGON_H
// -----------------------------------------------------------------------------

#include "AtiDemo.h"
#include "NormalMode.h"

// -----------------------------------------------------------------------------

class Dragon {
public:
	static void Cleanup(void) throw(Exception);
	static void Initialize(void) throw(Exception);

	static void Physics(PhysicsType type) throw();

	static void SetMode(void);

	static const Vector& Position(void) { return m_position; }
	static const Matrix& Rotation(void) { return m_rotation; }

private:
	static Vector	m_position;
	static Matrix	m_rotation;
};

// -----------------------------------------------------------------------------
#endif
