/*==========================================================================
* RESETENG.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL function to reset the engine.                                        *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_resetengine - reset engine and clear any FIFO errors
  
  This function resets the GUI engine and clears any FIFO errors that may
  have occured by previous operations. It also enables the engine.
-------------------------------------------------------------------------- */
void PGL_resetengine(void)
{
    // reset engine
    regw(GEN_TEST_CNTL, regr(GEN_TEST_CNTL) & (~GUI_ENGINE_ENABLE));

    // enable engine
    regw(GEN_TEST_CNTL, regr(GEN_TEST_CNTL) | GUI_ENGINE_ENABLE);

    // Ensure engine is not locked up by clearing any FIFO errors
    regw(BUS_CNTL, (regr(BUS_CNTL) & 0xff00ffff) | 0x00ae0000);
}

