/*==========================================================================
  COMPARE.C

  Example code to show effect of mix and comparing of the source and
  destination.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // Check for 24 bpp mode - Compare destination is not directly
    // supported in 24 bpp modes
    if (modeinfo.bpp == 24)
    {
        // disable accelerator mode and switch back to VGA text mode
        close_mode ();

        printf ("Compare destination is not supported in 24 bpp modes.\n");
        return (1);
    }

    // setup engine context and clear screen
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // Fill the screen with two filled rectangles - BLUE on top, YELLOW below

    // Set foreground mix to OVERPAINT
    set_fg_mix (S_MIX);

    set_fg_color (get_color_code (LIGHTBLUE));
    draw_rectangle (0, 0, modeinfo.xres / 2, modeinfo.yres / 4);

    set_fg_color (get_color_code (YELLOW));
    draw_rectangle (0, modeinfo.yres / 4, modeinfo.xres / 2, modeinfo.yres / 4);

    // wait for a carriage return     // show screen before operation
    getch ();

    // Draw a rectangle on top of the previously drawn one. The YELLOW
    // rectangle on the screen is used as the source comparison. Since the
    // compare color is YELLOW and the compare function is EQUAL, the
    // resulting rectangle draw will not affect the YELLOW rectangle. The
    // LIGHTBLUE rectangle, however, will be overwritten. The show mixing,
    // the resulting rectangle (written on top of the LIGHTBLUE rectangle)
    // will be LIGHTMAGENTA (LIGHTBLUE destination OR LIGHTRED source).

    // set mixes
    set_fg_mix (D_OR_S_MIX);
    set_bg_mix (D_MIX);

    // compare color = YELLOW
    wait_for_fifo (3);
    regw (CLR_CMP_CLR, get_color_code (YELLOW));

    // allow all bits to pass in comparison
    regw (CLR_CMP_MASK, 0xFFFFFFFF);

    // compare source = destination
    regw (CLR_CMP_CNTL, COMPARE_EQUAL);

    // draw LIGHTRED rectangle over both LIGHTBLUE & YELLOW regions
    set_fg_color (get_color_code (LIGHTRED));
    draw_rectangle (0, 0, modeinfo.xres / 2, modeinfo.yres / 2);

    // wait for a carriage return     // show destination after operation
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

