; ===========================================================================
; ROMCAL00.ASM
;
; Mach64 ROM interface function 00h - Load coprocessor CRTC parameters.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_LOADMODEPARMS - ROM function 00h
;
; Load accelerator mode parameters to determine the mode to be invoked by a
; following call to SET_DISPLAY_MODE. Input parameters are fetched from the
; stack. See PGL.H for symbolic values.
;
; Inputs : WORD resolution code
;            12h - 640x480
;            6ah - 800x600
;            55h - 1024x768
;            80h - use eeprom offset
;            81h - use crt table pointer
;            82h - other (OEM specific mode)
;            83h - 1280x1024
;            84h - 1600x1200
;
;          WORD pitch code
;            0   - 1024
;            1   - don't change
;            2   - pitch size = resolution width
;
;          WORD deep color code
;            1   - 4 bpp
;            2   - 8 bpp
;            3   - 15 bpp (555)
;            4   - 16 bpp (565)
;            5   - 24 bpp (RGB or BGR depending on DAC)
;            6   - 32 bpp (RGBa, aRGB, BGRa, aBGR depending on DAC)
;
;          WORD palettized flag
;            0   - disabled
;            1   - enabled
;
;          DWORD PTR mode table pointer
;            (passed to ROM in DX:BX if res code = 81h)
;
;          WORD eeprom offset
;            (passed to ROM in BX if res code = 80h)
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_loadmodeparms

IFDEF mem_S
ROM_loadmodeparms proc near
ELSE
ROM_loadmodeparms proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    cx
            push    dx

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     ax, WORD PTR [bp+PARM]      ; get resolution code
            mov     ch, al
            mov     ax, WORD PTR [bp+PARM+2]    ; get pitch code
            shl     al, 6
            mov     cl, al
            mov     ax, WORD PTR [bp+PARM+4]    ; get deep color code
            and     al, 7
            or      cl, al
            mov     ax, WORD PTR [bp+PARM+6]    ; get palettized flag
            and     ax, 1
            shl     al, 4
            or      cl, al

            ; zero pointer registers
            xor     bx, bx
            xor     dx, dx

            ; load bx if ch = 80h
            cmp     ch, 80h
            jne     @F
            mov     bx, WORD PTR [bp+PARM+12]   ; get eeprom offset
@@:
            ; load dx:bx if ch = 81h
            cmp     ch, 81h
            jne     @F
            mov     bx, WORD PTR [bp+PARM+8]    ; get crt pointer offset
            mov     dx, WORD PTR [bp+PARM+10]   ; get crt pointer segment
@@:
            ; setup ROM call
            mov     ax, 0                       ; function 00h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     dx
            pop     cx
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_loadmodeparms endp

            end

