; ===========================================================================
; ROMCAL08.ASM
;
; Mach64 ROM interface function 08h - Get query structure size in bytes.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_GETQUERYSIZE - ROM function 08h
;
; Retrieve the query size in bytes to reserve for a subsequent call to
; ROM_FILLQUERYSTRUCTURE. The size of the header or header & mode tables can
; be retrieved. Input parameters are fetched from the stack. See PGL.H for
; symbolic values.
;
; Inputs : WORD information type
;            0 - header information only
;            1 - header and mode table information
;
; Outputs: Returns size in bytes in ax
;            size in bytes
;               or
;            0 if the function returns with an error
; ---------------------------------------------------------------------------
            public  ROM_getquerysize

IFDEF mem_S
ROM_getquerysize proc near
ELSE
ROM_getquerysize proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    cx

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     ax, WORD PTR [bp+PARM]      ; get info type flag
            mov     cl, al

            ; setup ROM call
            mov     ax, 8                       ; function 08h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; check for errors in AH
            cmp     ah, 0
            je      no_error

            ; error: set ax to zero
            mov     ax, 0
            jmp     qsize_exit

no_error:
            ; no error: move size from cx to ax
            mov     ax, cx

qsize_exit:
            ; restore saved registers
            pop     cx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_getquerysize endp

            end

